#version 330 core

in vec3 vertex_position;
in vec3 vertex_normal;
in vec2 vertex_uv;

out vec4 fragment_color;

uniform mat4 normal_transform;

uniform sampler2D diffuse_map;
uniform sampler2D specular_map;
uniform sampler2D normal_map;

uniform vec3 global_diffuse;
uniform vec3 global_specular;
uniform float global_glossiness;

uniform float t;

uniform mat4 model_to_view;
/*
void main()
{
    fragment_color = texture(tex, uv) * vec4(color, 1.0);
}
*/
const float screen_gamma = 2.2; // Assume the monitor is calibrated to the sRGB color space

const float specular_exponent = 5.0;



uniform vec3 light1_position;
uniform vec3 light2_position;
uniform vec3 light1_intensity;
uniform vec3 light2_intensity;
uniform vec3 ambient_light;
uniform float desaturate_multiplier;
uniform float fade_to_black_multiplier;



void main()
{
    //vec3 light_position = (model_to_view * vec4(light_in_model_coordinates, 1.0)).xyz;

    vec3 diffuse_color = texture(diffuse_map, vertex_uv).rgb;
    vec3 specular_color = texture(specular_map, vertex_uv).rgb;
    vec3 normal = vertex_normal;
    vec3 point_to_eye = - vertex_position;
    vec3 point_to_eye_dir = normalize(point_to_eye);

    //LIGHT1
    vec3 point_to_light1 = light1_position - vertex_position;
    vec3 point_to_light1_dir = normalize(point_to_light1);

    float light1_distance = length(point_to_light1);
    vec3 light1_intensity_at_point = light1_intensity / light1_distance / light1_distance;

    vec3 ambient1 = ambient_light * diffuse_color;
    vec3 diffuse1 = diffuse_color * clamp(dot(point_to_light1_dir, normal), 0.0, 1.0);

    //blinn-phong specular:
    vec3 half_vector1 = normalize(point_to_light1_dir + point_to_eye_dir);
    vec3 specular1 = vec3(0.0); //specular_color * pow(clamp(dot(half_vector, normal), 0.0, 1.0), specular_exponent);
    
    vec3 light1_at_point = light1_intensity_at_point * (diffuse1 + specular1) + ambient1;

    //LIGHT2
    vec3 point_to_light2 = light2_position - vertex_position;
    vec3 point_to_light2_dir = normalize(point_to_light2);

    float light2_distance = length(point_to_light2);
    vec3 light2_intensity_at_point = light2_intensity / light2_distance / light2_distance;

    vec3 ambient2 = ambient_light * diffuse_color;
    vec3 diffuse2 = diffuse_color * clamp(dot(point_to_light2_dir, normal), 0.0, 1.0);

    //blinn-phong specular:
    vec3 half_vector2 = normalize(point_to_light2_dir + point_to_eye_dir);
    vec3 specular2 = vec3(0.0); //specular_color * pow(clamp(dot(half_vector, normal), 0.0, 1.0), specular_exponent);
    
    vec3 light2_at_point = light2_intensity_at_point * (diffuse2 + specular2) + ambient2;

    //OUTPUT
    fragment_color = vec4(vec3(fade_to_black_multiplier), 1.0) * (vec4(light1_at_point + light2_at_point, 1.0));
}